<?php

namespace App\Console;

use App\Console\Commands\ScheduleBrandAnalytics;
use App\Console\Commands\ScheduleCreatorAnalytics;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        ScheduleBrandAnalytics::class,
        ScheduleCreatorAnalytics::class,
        \App\Console\Commands\ProcessScheduledPosts::class,
        \App\Console\Commands\TestCreatorScheduledPost::class,
        \App\Console\Commands\SyncCompetitorData::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // Schedule brand analytics updates to run nightly at 2 AM
        $schedule->command('analytics:schedule-update')->dailyAt('02:00');
        
        // Schedule creator analytics updates to run nightly at 3 AM
        $schedule->command('analytics:schedule-creator-update')->dailyAt('03:00');
        
        // Schedule scheduled posts processing to run every minute
        $schedule->command('scheduled-posts:process')->everyMinute();
        
        // Schedule competitor data sync to run every 6 hours
        $schedule->command('competitors:sync')->everySixHours();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}