<?php

namespace App\Http\Controllers\Agency;

use App\Http\Controllers\Controller;
use App\Models\Campaign;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReportsController extends Controller
{
    /**
     * Display the agency reports.
     */
    public function index()
    {
        // Get campaigns for the current agency
        $campaigns = Campaign::where('agency_id', Auth::id())->with('brand')->get();
        
        // Get brands linked to this agency
        $brands = Auth::user()->brands;
        
        // Calculate statistics
        $totalCampaigns = $campaigns->count();
        $activeCampaigns = $campaigns->where('status', 'active')->count();
        $totalBudget = $campaigns->sum('budget');
        
        // Group campaigns by brand
        $brandCampaigns = [];
        foreach ($brands as $brand) {
            $brandCampaigns[$brand->name] = $campaigns->where('brand_id', $brand->id)->count();
        }
        
        // Group budgets by brand
        $brandBudgets = [];
        foreach ($brands as $brand) {
            $brandBudgets[$brand->name] = $campaigns->where('brand_id', $brand->id)->sum('budget');
        }
        
        return view('agency.reports.index', compact(
            'totalCampaigns', 
            'activeCampaigns', 
            'totalBudget', 
            'brandCampaigns',
            'brandBudgets'
        ));
    }
}