<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ReelRequest;
use App\Jobs\HandleReelCallback;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class ReelController extends Controller
{
    /**
     * Handle callback from the reel processing microservice.
     */
    public function callback(Request $request)
    {
        try {
            // Dispatch job to handle the callback asynchronously
            HandleReelCallback::dispatch($request->all(), $request->header('X-Processor-Signature'));
            
            return response()->json(['status' => 'accepted'], 202);
        } catch (\Exception $e) {
            Log::error('Reel callback processing failed: ' . $e->getMessage(), [
                'payload' => $request->all(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return response()->json(['error' => 'Processing failed'], 500);
        }
    }
}