<?php

namespace App\Http\Controllers\Brand;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function index()
    {
        // Get users for the current brand
        $users = auth()->user()->brand->users;
        
        return view('brand.users.index', compact('users'));
    }
    
    public function store(Request $request)
    {
        $request->validate([
            'email' => 'required|email|unique:users,email',
            'name' => 'required|string|max:255',
            'role' => 'required|in:admin,creator,user',
        ]);
        
        // Create invite
        $invite = \App\Models\Invite::create([
            'tenant_id' => auth()->user()->tenant_id,
            'email' => $request->email,
            'token' => \Illuminate\Support\Str::random(32),
            'role' => $request->role,
            'expires_at' => now()->addDays(7),
        ]);
        
        // Send invite email (placeholder)
        // Mail::to($request->email)->send(new InviteMail($invite));
        
        return redirect()->back()->with('success', 'Invite sent successfully!');
    }
    
    public function destroy($id)
    {
        $user = \App\Models\User::findOrFail($id);
        
        // Check if user belongs to the same brand
        if ($user->brand_id !== auth()->user()->brand_id) {
            return redirect()->back()->with('error', 'Unauthorized action.');
        }
        
        $user->delete();
        
        return redirect()->back()->with('success', 'User removed successfully!');
    }
}
