<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCreatorScheduledPostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'social_account_id' => 'required|exists:social_accounts,id',
            'caption' => 'nullable|string|max:2200',
            'media_refs' => 'nullable|array',
            'media_refs.*.url' => 'required_with:media_refs|string',
            'media_refs.*.type' => 'required_with:media_refs|string|in:image,video',
            'publish_time' => 'required|date',
            'timezone' => 'required|string',
            'campaign_id' => 'nullable|exists:campaigns,id',
            'post_visibility' => 'required|in:public,draft',
            'recurrence' => 'nullable|array',
            'auto_reply_enabled' => 'boolean',
            'auto_reply_template_id' => 'nullable|exists:auto_reply_templates,id',
        ];
    }
}