<?php

namespace App\Jobs;

use App\Models\AiTask;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Str;

class EnqueueAiTaskJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $type;
    protected $brandId;
    protected $creatorId;
    protected $payload;

    /**
     * Create a new job instance.
     *
     * @param string $type
     * @param int $brandId
     * @param int|null $creatorId
     * @param array $payload
     * @return void
     */
    public function __construct($type, $brandId, $creatorId, $payload)
    {
        $this->type = $type;
        $this->brandId = $brandId;
        $this->creatorId = $creatorId;
        $this->payload = $payload;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // Generate a UUID for the job
        $jobId = (string) Str::uuid();

        // Create a new row in ai_tasks with status = "pending"
        $aiTask = AiTask::create([
            'job_id' => $jobId,
            'type' => $this->type,
            'status' => 'pending',
            'brand_id' => $this->brandId,
            'creator_id' => $this->creatorId,
            'result_text' => null,
            'result_meta' => null,
            'provider' => null,
        ]);

        // Prepare the job payload
        $jobPayload = [
            'job_id' => $jobId,
            'type' => $this->type,
            'brand_id' => $this->brandId,
            'creator_id' => $this->creatorId,
            'payload' => $this->payload,
        ];

        // Push the job payload as JSON into Redis list `ai:jobs`
        Redis::lpush('ai:jobs', json_encode($jobPayload));
    }
}