<?php

namespace App\Jobs;

use App\Models\Brand;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

class UpdateBrandAnalytics implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // Get all brands
        $brands = Brand::all();
        
        // Process each brand
        foreach ($brands as $brand) {
            // Dispatch the SyncBrandSocialAccounts job for this brand
            SyncBrandSocialAccounts::dispatch($brand);
        }
    }
}
