<?php

namespace App\Jobs;

use App\Models\User;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

class UpdateCreatorAnalytics implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // Get all creators (users with creator role)
        $creators = User::whereHas('roles', function ($query) {
            $query->where('name', 'creator');
        })->get();
        
        // Process each creator
        foreach ($creators as $creator) {
            // Dispatch the SyncCreatorSocialAccounts job for this creator
            SyncCreatorSocialAccounts::dispatch($creator);
        }
    }
}