<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ad extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'campaign_id',
        'brand_id',
        'name',
        'product_info',
        'audience',
        'tone',
        'budget',
        'currency',
        'status',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'budget' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    /**
     * Get the campaign that owns the ad.
     */
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    /**
     * Get the brand that owns the ad.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the variants for the ad.
     */
    public function variants()
    {
        return $this->hasMany(AdVariant::class);
    }

    /**
     * Get the active variants for the ad.
     */
    public function activeVariants()
    {
        return $this->variants()->where('is_active', true);
    }

    /**
     * Get the winning variant for the ad.
     */
    public function winningVariant()
    {
        return $this->variants()->where('is_winner', true)->first();
    }

    /**
     * Check if the ad has a winning variant.
     */
    public function hasWinner()
    {
        return $this->winningVariant() !== null;
    }

    /**
     * Get the performance metrics for all variants of this ad.
     */
    public function performanceMetrics()
    {
        return $this->hasManyThrough(AdPerformanceMetric::class, AdVariant::class);
    }
}