<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AiTask extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'job_id',
        'type',
        'status',
        'brand_id',
        'creator_id',
        'result_text',
        'result_meta',
        'provider',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'result_meta' => 'array',
        'job_id' => 'string',
    ];

    /**
     * Get the brand that owns the AI task.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the creator that owns the AI task.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
}