<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AutoReplySuggestion extends Model
{
    use HasFactory;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'social_comment_id',
        'brand_id',
        'creator_id',
        'ai_job_id',
        'suggested_reply',
        'confidence_score',
        'brand_voice',
        'preferred_tone',
        'is_approved',
        'is_posted',
        'is_favorite',
        'posted_at',
        'meta',
    ];
    
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'meta' => 'array',
        'confidence_score' => 'decimal:2',
        'is_approved' => 'boolean',
        'is_posted' => 'boolean',
        'is_favorite' => 'boolean',
        'posted_at' => 'datetime',
    ];
    
    /**
     * Get the social comment that owns the suggestion.
     */
    public function socialComment()
    {
        return $this->belongsTo(SocialComment::class);
    }
    
    /**
     * Get the brand that owns the suggestion.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }
    
    /**
     * Get the creator that owns the suggestion.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
    
    /**
     * Get the AI job that generated the suggestion.
     */
    public function aiJob()
    {
        return $this->belongsTo(AiJob::class);
    }
}