<?php

namespace App\Models;

use Database\Factories\BrandFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Brand extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'name',
        'slug',
        'settings',
    ];
    
    protected $casts = [
        'settings' => 'array',
    ];
    
    /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BrandFactory::new();
    }
    
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    public function users()
    {
        return $this->hasMany(User::class);
    }
    
    public function contents()
    {
        return $this->hasMany(Content::class);
    }
    
    public function agencies()
    {
        return $this->belongsToMany(User::class, 'agency_brand');
    }
    
    public function socialAccounts()
    {
        return $this->hasMany(SocialAccount::class);
    }
    
    public function socialAggregates()
   {
       return $this->hasMany(SocialAggregate::class);
   }
   
   /**
    * Get the contracts for the brand.
    */
   public function contracts()
   {
       return $this->hasMany(Contract::class);
   }
   
   /**
    * Get the payments for the brand.
    */
   public function payments()
   {
       return $this->hasMany(Payment::class);
   }
   
   /**
    * Get the proposals for the brand.
    */
   public function proposals()
   {
       return $this->hasMany(Proposal::class);
   }
}

