<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CreatorAutoReplySetting extends Model
{
    use HasFactory;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'enabled',
        'preferred_tone',
        'confidence_threshold',
        'auto_approve_high_confidence',
        'auto_approve_confidence_threshold',
        'rule_based_triggers',
        'excluded_keywords',
        'creator_guidelines',
    ];
    
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'rule_based_triggers' => 'array',
        'excluded_keywords' => 'array',
        'creator_guidelines' => 'array',
        'enabled' => 'boolean',
        'auto_approve_high_confidence' => 'boolean',
        'confidence_threshold' => 'decimal:2',
        'auto_approve_confidence_threshold' => 'decimal:2',
    ];
    
    /**
     * Get the user that owns the settings.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}