<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InfluencerMatch extends Model
{
    use HasFactory;

    protected $table = 'matches';

    protected $fillable = [
        'creator_id',
        'campaign_id',
        'score',
        'reasons',
    ];

    protected $casts = [
        'reasons' => 'array',
        'score' => 'decimal:2',
    ];

    /**
     * Get the creator for this match.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }

    /**
     * Get the campaign for this match.
     */
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }
}