<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MessageThreadParticipant extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'thread_id',
        'user_id',
        'is_read',
        'last_read_at',
        'joined_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_read' => 'boolean',
        'last_read_at' => 'datetime',
        'joined_at' => 'datetime',
    ];

    /**
     * Get the thread that this participant belongs to.
     */
    public function thread()
    {
        return $this->belongsTo(MessageThread::class, 'thread_id');
    }

    /**
     * Get the user that this participant represents.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}