<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Proposal extends Model
{
    use HasFactory;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'brand_id',
        'creator_id',
        'agency_id',
        'title',
        'message',
        'type',
        'budget',
        'duration',
        'deliverables',
        'attachment_path',
        'status',
        'read_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'deliverables' => 'array',
        'budget' => 'decimal:2',
        'read_at' => 'datetime',
    ];

    /**
     * Get the brand that owns the proposal.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the creator that owns the proposal.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
    
    /**
    * Get the agency that created the proposal.
    */
   public function agency()
   {
       return $this->belongsTo(User::class, 'agency_id');
   }
   
   /**
    * Get the comments for the proposal.
    */
   public function comments()
   {
       return $this->hasMany(ProposalComment::class);
   }
   
   /**
    * Get the message thread associated with the proposal.
    */
   public function thread()
   {
       return $this->hasOne(MessageThread::class, 'proposal_id');
   }
   
   /**
    * Get the contract associated with the proposal.
    */
   public function contract()
   {
       return $this->hasOne(Contract::class);
   }
   
   /**
    * Get the payment associated with the proposal.
    */
   public function payment()
   {
       return $this->hasOne(Payment::class);
   }
   
   /**
    * Get the proposal transitions for the proposal.
    */
   public function transitions()
   {
       return $this->hasMany(ProposalTransition::class);
   }
   
   /**
    * Get the AI job associated with the proposal.
    */
   public function aiJob()
   {
       return $this->belongsTo(AiJob::class, 'ai_job_id');
   }
   
   /**
    * Get the proposal sections for the proposal.
    */
   public function sections()
   {
       return $this->hasMany(ProposalSection::class)->orderBy('order');
   }
}
