<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProposalRequest extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'brand_id',
        'creator_id',
        'campaign_brief',
        'tone',
        'budget_range',
        'deliverables',
        'status',
        'ai_job_id',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'deliverables' => 'array',
        'budget_range' => 'array',
        'creator_id' => 'integer',
    ];

    /**
     * Get the brand that owns the proposal request.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the creator for whom the proposal is requested.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }

    /**
     * Get the AI job associated with the proposal request.
     */
    public function aiJob()
    {
        return $this->belongsTo(AiJob::class, 'ai_job_id');
    }
}