<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProposalTransition extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'proposal_id',
        'from_status',
        'to_status',
        'changed_by',
        'notes',
    ];

    /**
     * Get the proposal that owns the transition.
     */
    public function proposal()
    {
        return $this->belongsTo(Proposal::class);
    }

    /**
     * Get the user who made the transition.
     */
    public function changedBy()
    {
        return $this->belongsTo(User::class, 'changed_by');
    }
}