<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReelPostAttempt extends Model
{
    use HasFactory;

    protected $fillable = [
        'scheduled_reel_id',
        'provider',
        'request_payload',
        'response_summary',
    ];

    protected $casts = [
        'request_payload' => 'array',
        'response_summary' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the scheduled reel that owns this post attempt.
     */
    public function scheduledReel()
    {
        return $this->belongsTo(ScheduledReel::class);
    }
}