<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\Contract;

class ContractSigned extends Notification
{
    use Queueable;

    protected $contract;

    /**
     * Create a new notification instance.
     *
     * @param Contract $contract
     * @return void
     */
    public function __construct(Contract $contract)
    {
        $this->contract = $contract;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('Contract Signed for Proposal: ' . $this->contract->proposal->title)
                    ->greeting('Hello ' . $notifiable->name . '!')
                    ->line('The contract for your proposal has been signed: ' . $this->contract->proposal->title)
                    ->line('The next step is to process the payment.')
                    ->action('View Contract', url('/brand/proposals/' . $this->contract->proposal->id))
                    ->line('Thank you for using our platform!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'contract_id' => $this->contract->id,
            'proposal_id' => $this->contract->proposal->id,
            'proposal_title' => $this->contract->proposal->title,
            'message' => 'The contract for your proposal has been signed: ' . $this->contract->proposal->title,
        ];
    }
}