<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\Proposal;

class ProposalAccepted extends Notification
{
    use Queueable;

    protected $proposal;

    /**
     * Create a new notification instance.
     *
     * @param Proposal $proposal
     * @return void
     */
    public function __construct(Proposal $proposal)
    {
        $this->proposal = $proposal;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('Proposal Accepted: ' . $this->proposal->title)
                    ->greeting('Hello ' . $notifiable->name . '!')
                    ->line('Your proposal has been accepted: ' . $this->proposal->title)
                    ->line('A contract will be sent to you shortly.')
                    ->action('View Proposal', url('/creator/proposals/' . $this->proposal->id))
                    ->line('Thank you for using our platform!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'proposal_id' => $this->proposal->id,
            'proposal_title' => $this->proposal->title,
            'message' => 'Your proposal has been accepted: ' . $this->proposal->title,
        ];
    }
}