<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ReelScheduled extends Notification implements ShouldQueue
{
    use Queueable;

    protected $scheduledReel;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($scheduledReel)
    {
        $this->scheduledReel = $scheduledReel;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database', 'mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Reel Scheduled Successfully')
            ->line('Your reel has been scheduled successfully.')
            ->line('Template: ' . $this->scheduledReel->template)
            ->line('Scheduled for: ' . $this->scheduledReel->scheduled_at->format('Y-m-d H:i'))
            ->action('View Reel', url('/' . ($this->scheduledReel->owner_type === 'brand' ? 'brand' : 'creator') . '/reels/' . $this->scheduledReel->id))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'message' => 'Your reel has been scheduled successfully.',
            'reel_id' => $this->scheduledReel->id,
            'template' => $this->scheduledReel->template,
            'scheduled_at' => $this->scheduledReel->scheduled_at,
            'status' => $this->scheduledReel->status,
        ];
    }
}