<?php

namespace App\Policies;

use App\Models\User;
use App\Models\CompetitorAlert;

class CompetitorAlertPolicy
{
    /**
     * Determine if the user can view the alert.
     */
    public function view(User $user, CompetitorAlert $alert): bool
    {
        if (!$user->hasRole('brand_admin')) {
            return false;
        }

        return $user->brand_id === $alert->brand_id;
    }

    /**
     * Determine if the user can update the alert.
     */
    public function update(User $user, CompetitorAlert $alert): bool
    {
        if (!$user->hasRole('brand_admin')) {
            return false;
        }

        return $user->brand_id === $alert->brand_id;
    }

    /**
     * Determine if the user can delete the alert.
     */
    public function delete(User $user, CompetitorAlert $alert): bool
    {
        if (!$user->hasRole('brand_admin')) {
            return false;
        }

        return $user->brand_id === $alert->brand_id;
    }
}