<?php

namespace App\Policies;

use App\Models\User;
use App\Models\CompetitorBrand;

class CompetitorBrandPolicy
{
    /**
     * Determine if the user can view the competitor brand.
     */
    public function view(User $user, CompetitorBrand $competitor): bool
    {
        // Only brand_admin can view competitors
        if (!$user->hasRole('brand_admin')) {
            return false;
        }

        // User must belong to the same brand
        return $user->brand_id === $competitor->brand_id;
    }

    /**
     * Determine if the user can create competitor brands.
     */
    public function create(User $user): bool
    {
        return $user->hasRole('brand_admin');
    }

    /**
     * Determine if the user can update the competitor brand.
     */
    public function update(User $user, CompetitorBrand $competitor): bool
    {
        if (!$user->hasRole('brand_admin')) {
            return false;
        }

        return $user->brand_id === $competitor->brand_id;
    }

    /**
     * Determine if the user can delete the competitor brand.
     */
    public function delete(User $user, CompetitorBrand $competitor): bool
    {
        if (!$user->hasRole('brand_admin')) {
            return false;
        }

        return $user->brand_id === $competitor->brand_id;
    }
}