<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use JeroenNoten\LaravelAdminLte\Events\BuildingMenu;
use App\Http\Controllers\SuperAdmin\SidebarController;

class AdminLTEServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Listen to the BuildingMenu event to inject badge counts
        $this->app['events']->listen(BuildingMenu::class, function (BuildingMenu $event) {
            // Only inject badges for super admin users
            if (auth()->check() && auth()->user()->hasRole('superadmin')) {
                $badges = SidebarController::getBadgeCounts();
                
                // Inject badge counts into menu items
                $this->injectBadges($event->menu, $badges);
            }
        });

        // Share global search data with views
        View::composer('*', function ($view) {
            if (auth()->check() && auth()->user()->hasRole('superadmin')) {
                $view->with('isSuperAdmin', true);
            }
        });
    }

    /**
     * Recursively inject badge counts into menu items
     */
    private function injectBadges(&$menu, array $badges): void
    {
        foreach ($menu as &$item) {
            // Check if item has a label key that matches our badge keys
            if (isset($item['label']) && isset($badges[$item['label']])) {
                $count = $badges[$item['label']];
                
                // Only show badge if count > 0
                if ($count > 0) {
                    $item['label'] = SidebarController::formatBadgeCount($count);
                } else {
                    // Remove label if count is 0
                    unset($item['label']);
                }
            }

            // Recursively process submenu items
            if (isset($item['submenu']) && is_array($item['submenu'])) {
                $this->injectBadges($item['submenu'], $badges);
            }
        }
    }
}