<?php

namespace App\Services\SocialProviders;

use App\Models\SocialAccount;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;

interface ProviderInterface
{
    /**
     * Redirect the user to the provider's authentication page.
     *
     * @param Request $request
     * @return RedirectResponse
     */
    public function redirectToProvider(Request $request): RedirectResponse;

    /**
     * Handle the callback from the provider.
     *
     * @param Request $request
     * @return array
     */
    public function handleCallback(Request $request): array;

    /**
     * Fetch account details from the provider.
     *
     * @param SocialAccount $account
     * @return array
     */
    public function fetchAccountDetails(SocialAccount $account): array;

    /**
     * Fetch recent posts from the provider.
     *
     * @param SocialAccount $account
     * @param int $limit
     * @return array
     */
    public function fetchRecentPosts(SocialAccount $account, int $limit = 20): array;

    /**
     * Refresh the access token for the account.
     *
     * @param SocialAccount $account
     * @return bool
     */
    public function refreshToken(SocialAccount $account): bool;
    
    /**
     * Post content to the provider.
     *
     * @param ScheduledPost $scheduledPost
     * @param SocialAccount $account
     * @return array
     */
    public function postContent($scheduledPost, SocialAccount $account): array;
}