<?php

namespace Database\Factories;

use App\Models\Contract;
use App\Models\Proposal;
use App\Models\Brand;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ContractFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Contract::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
   {
       // Get existing records or create new ones if none exist
       $proposal = Proposal::inRandomOrder()->first() ?? Proposal::factory()->create();
       $brand = Brand::inRandomOrder()->first() ?? Brand::factory()->create();
       $creator = User::whereHas('roles', function ($q) {
           $q->where('name', 'creator');
       })->inRandomOrder()->first() ?? User::factory()->create();
       
       return [
           'proposal_id' => $proposal->id,
           'brand_id' => $brand->id,
           'creator_id' => $creator->id,
           'title' => $this->faker->sentence,
           'description' => $this->faker->paragraph,
           'terms' => $this->faker->text,
           'start_date' => $this->faker->date(),
           'end_date' => $this->faker->date(),
           'value' => $this->faker->randomFloat(2, 100, 10000),
           'currency' => 'USD',
           'status' => $this->faker->randomElement(['draft', 'sent', 'signed', 'active', 'completed', 'terminated']),
           'brand_signature' => null,
           'brand_signed_at' => null,
           'creator_signature' => null,
           'creator_signed_at' => null,
           'document_path' => null,
       ];
   }
}