<?php

namespace Database\Factories;

use App\Models\ReelInput;
use App\Models\ReelRequest;
use App\Models\SocialPost;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ReelInput>
 */
class ReelInputFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'reel_request_id' => ReelRequest::factory(),
            'source_post_id' => SocialPost::factory(),
            'provider' => $this->faker->randomElement(['instagram', 'youtube', 'tiktok', 'facebook']),
            'source_url' => $this->faker->url(),
            'meta' => [
                'caption' => $this->faker->sentence(),
                'created_at' => $this->faker->dateTimeThisYear(),
            ],
        ];
    }
}