<?php

namespace Database\Factories;

use App\Models\ReelRequest;
use App\Models\User;
use App\Models\Brand;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ReelRequest>
 */
class ReelRequestFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'brand_id' => Brand::factory(),
            'status' => $this->faker->randomElement(['queued', 'processing', 'ready', 'failed', 'cancelled']),
            'template' => $this->faker->randomElement(['template1', 'template2', 'template3', 'custom']),
            'options' => [
                'aspect_ratio' => $this->faker->randomElement(['9:16', '1:1', '4:5']),
                'music' => $this->faker->optional()->word(),
                'overlay' => $this->faker->optional()->sentence(),
            ],
            'job_id' => $this->faker->optional()->uuid(),
            'result_path' => $this->faker->optional()->filePath(),
            'duration' => $this->faker->optional()->numberBetween(10, 120),
            'error_message' => $this->faker->optional()->sentence(),
        ];
    }

    /**
     * Indicate that the reel is ready.
     */
    public function ready(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'ready',
            'job_id' => $this->faker->uuid(),
            'result_path' => 'reels/result_' . $this->faker->uuid() . '.mp4',
            'duration' => $this->faker->numberBetween(10, 120),
        ]);
    }

    /**
     * Indicate that the reel is processing.
     */
    public function processing(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'processing',
            'job_id' => $this->faker->uuid(),
        ]);
    }

    /**
     * Indicate that the reel has failed.
     */
    public function failed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'failed',
            'error_message' => $this->faker->sentence(),
        ]);
    }

    /**
     * Indicate that the reel is queued.
     */
    public function queued(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'queued',
        ]);
    }
}