<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if phone column already exists
        if (!Schema::hasColumn('users', 'phone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('phone')->nullable()->after('email');
            });
        }
        
        // Check if meta column already exists
        if (!Schema::hasColumn('users', 'meta')) {
            Schema::table('users', function (Blueprint $table) {
                $table->json('meta')->nullable()->after('phone');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Check if columns exist before dropping
        if (Schema::hasColumn('users', 'phone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('phone');
            });
        }
        
        if (Schema::hasColumn('users', 'meta')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('meta');
            });
        }
    }
};
