<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('proposals', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('brand_id');
            $table->unsignedBigInteger('creator_id');
            $table->string('title');
            $table->text('message');
            $table->string('type'); // Collaboration, Sponsored Post, Affiliate, Long-term Partnership
            $table->decimal('budget', 10, 2)->nullable();
            $table->string('duration')->nullable(); // days/weeks/months
            $table->json('deliverables')->nullable(); // e.g., 1 Instagram post, 2 reels, 1 YouTube video
            $table->string('attachment_path')->nullable();
            $table->string('status')->default('sent'); // sent, draft, accepted, rejected
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            
            // Indexes for better performance
            $table->index(['brand_id', 'creator_id']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('proposals');
    }
};
