<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_prompts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('campaign_id')->nullable();
            $table->unsignedBigInteger('brand_id');
            $table->unsignedBigInteger('creator_id')->nullable();
            $table->string('title');
            $table->text('prompt');
            $table->string('category')->nullable();
            $table->string('platform')->nullable();
            $table->json('suggested_hashtags')->nullable();
            $table->json('suggested_tags')->nullable();
            $table->enum('status', ['active', 'used', 'archived'])->default('active');
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('campaign_id')->references('id')->on('campaigns')->onDelete('set null');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            // Indexes for better performance
            $table->index('campaign_id');
            $table->index('brand_id');
            $table->index('creator_id');
            $table->index('platform');
            $table->index('category');
            $table->index('status');
            $table->index('created_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_prompts');
    }
};
