<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reel_inputs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('reel_request_id');
            $table->unsignedBigInteger('source_post_id')->nullable();
            $table->string('provider')->nullable();
            $table->string('source_url')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
            
            $table->foreign('reel_request_id')->references('id')->on('reel_requests')->onDelete('cascade');
            $table->foreign('source_post_id')->references('id')->on('social_posts')->onDelete('cascade');
            
            $table->index('reel_request_id');
            $table->index('source_post_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reel_inputs');
    }
};