<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ai_jobs', function (Blueprint $table) {
            $table->id();
            $table->uuid('job_id')->unique();
            $table->string('type');
            $table->string('status')->default('queued'); // queued, generating, ready, failed
            $table->unsignedBigInteger('brand_id');
            $table->unsignedBigInteger('creator_id')->nullable();
            $table->unsignedBigInteger('proposal_id')->nullable();
            $table->longText('result_text')->nullable();
            $table->json('result_meta')->nullable();
            $table->string('provider')->nullable();
            $table->text('error_message')->nullable();
            $table->integer('token_usage')->default(0);
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
            
            $table->foreign('brand_id')->references('id')->on('brands');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('proposal_id')->references('id')->on('proposals')->onDelete('set null');
            
            $table->index(['brand_id', 'status']);
            $table->index('job_id');
            $table->index('type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ai_jobs');
    }
};