<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('content_ideas', function (Blueprint $table) {
            // Add creator_id column
            $table->unsignedBigInteger('creator_id')->nullable()->after('brand_id');
            
            // Add foreign key constraint
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            
            // Modify existing columns to be nullable since ideas can now belong to either brand or creator
            $table->unsignedBigInteger('brand_id')->nullable()->change();
            $table->unsignedBigInteger('campaign_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('content_ideas', function (Blueprint $table) {
            // Remove creator_id column
            $table->dropForeign(['creator_id']);
            $table->dropColumn('creator_id');
            
            // Revert columns to not nullable
            $table->unsignedBigInteger('brand_id')->nullable(false)->change();
            $table->unsignedBigInteger('campaign_id')->nullable(false)->change();
        });
    }
};