<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheduled_post_attempts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('scheduled_post_id');
            $table->unsignedBigInteger('social_account_id')->nullable();
            $table->string('provider');
            $table->json('request_payload')->nullable();
            $table->json('response_summary')->nullable();
            $table->string('status')->default('pending'); // pending, success, failed
            $table->text('error_message')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('scheduled_post_id');
            $table->index('social_account_id');
            $table->index('provider');
            $table->index('status');
            
            // Foreign key constraints
            $table->foreign('scheduled_post_id')->references('id')->on('scheduled_posts')->onDelete('cascade');
            $table->foreign('social_account_id')->references('id')->on('social_accounts')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheduled_post_attempts');
    }
};
