<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('competitor_insights', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->foreignId('competitor_brand_id')->constrained()->onDelete('cascade');
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            
            // Date range for the insight
            $table->date('start_date');
            $table->date('end_date');
            
            // Performance metrics comparison
            $table->json('competitor_metrics')->nullable(); // Competitor's metrics
            $table->json('brand_metrics')->nullable(); // Brand's own metrics for comparison
            $table->json('comparison_data')->nullable(); // Detailed comparison
            
            // AI-generated insights
            $table->json('topics')->nullable(); // Top topics/themes
            $table->json('sentiment_trends')->nullable(); // Sentiment analysis over time
            $table->json('top_posts')->nullable(); // Best performing posts
            $table->json('engagement_patterns')->nullable(); // When they post, engagement patterns
            $table->json('content_strategy')->nullable(); // Content type analysis
            $table->json('hashtag_analysis')->nullable(); // Hashtag performance
            
            // Recommendations
            $table->json('recommendations')->nullable(); // AI-generated actionable recommendations
            $table->text('summary')->nullable(); // Executive summary
            
            // Metadata
            $table->string('status')->default('pending'); // pending, processing, completed, failed
            $table->text('error_message')->nullable();
            $table->timestamp('generated_at')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['brand_id', 'start_date', 'end_date']);
            $table->index(['competitor_brand_id', 'start_date', 'end_date']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('competitor_insights');
    }
};