<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('knowledge_base_documents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->string('document_type'); // faq, manual, policy, terms, campaign, other
            $table->text('content');
            $table->text('content_summary')->nullable();
            $table->json('metadata')->nullable(); // tags, category, version, etc.
            $table->json('vector_embedding')->nullable(); // Store embeddings for RAG
            $table->string('file_path')->nullable(); // Original file path if uploaded
            $table->string('file_type')->nullable(); // pdf, docx, txt, etc.
            $table->integer('file_size')->nullable(); // in bytes
            $table->enum('status', ['active', 'archived', 'draft'])->default('active');
            $table->foreignId('uploaded_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('last_indexed_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['brand_id', 'status']);
            $table->index(['brand_id', 'document_type']);
            $table->fullText(['title', 'content']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('knowledge_base_documents');
    }
};