<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financial_audit_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('brand_id')->constrained('users')->onDelete('cascade');
            
            // Auditable entity
            $table->string('auditable_type'); // CampaignFinancial, FinancialReport, etc.
            $table->unsignedBigInteger('auditable_id');
            
            // Action details
            $table->enum('action', ['created', 'updated', 'deleted', 'viewed', 'exported', 'scenario_applied']);
            $table->text('description')->nullable();
            
            // Data changes
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();
            
            // Request metadata
            $table->string('ip_address', 45)->nullable();
            $table->string('user_agent')->nullable();
            
            // Export tracking (for data export actions)
            $table->enum('export_format', ['pdf', 'excel', 'csv'])->nullable();
            $table->string('export_filename')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['auditable_type', 'auditable_id']);
            $table->index(['brand_id', 'action', 'created_at']);
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financial_audit_logs');
    }
};