<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reputation_recommendations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('reputation_score_id')->constrained()->onDelete('cascade');
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            
            // Recommendation details
            $table->string('title');
            $table->text('description');
            $table->enum('priority', ['high', 'medium', 'low'])->default('medium');
            $table->enum('category', [
                'sentiment_improvement',
                'response_time',
                'trust_building',
                'compliance',
                'growth_strategy',
                'crisis_management'
            ]);
            
            // Impact estimation
            $table->decimal('estimated_impact', 5, 2)->default(0); // Potential score increase
            $table->enum('effort_level', ['low', 'medium', 'high'])->default('medium');
            $table->integer('estimated_days')->nullable();
            
            // Action tracking
            $table->enum('status', ['pending', 'in_progress', 'completed', 'dismissed'])->default('pending');
            $table->text('action_taken')->nullable();
            $table->foreignId('assigned_to')->nullable()->constrained('users');
            $table->timestamp('completed_at')->nullable();
            
            // AI metadata
            $table->text('ai_reasoning')->nullable();
            $table->json('supporting_data')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['reputation_score_id', 'priority']);
            $table->index(['brand_id', 'status']);
            $table->index('estimated_impact');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reputation_recommendations');
    }
};