<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BrandDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all tenants
        $tenants = \App\Models\Tenant::all();
        
        foreach ($tenants as $tenant) {
            // Create a brand for each tenant
            $brand = \App\Models\Brand::firstOrCreate([
                'tenant_id' => $tenant->id,
            ], [
                'name' => $tenant->name . ' Brand',
                'slug' => \Illuminate\Support\Str::slug($tenant->name . '-brand') . '-' . $tenant->id,
                'settings' => [],
            ]);
            
            // Create users for each tenant
            $users = [];
            
            // Create brand admin
            $admin = \App\Models\User::firstOrCreate([
                'email' => 'admin@' . $tenant->domain,
            ], [
                'tenant_id' => $tenant->id,
                'brand_id' => $brand->id,
                'name' => $tenant->name . ' Admin',
                'password' => bcrypt('password'),
            ]);
            if (!$admin->hasRole('brand_admin')) {
                $admin->assignRole('brand_admin');
            }
            $users[] = $admin;
            
            // Create 2 creators
            for ($i = 1; $i <= 2; $i++) {
                $creator = \App\Models\User::firstOrCreate([
                    'email' => 'creator' . $i . '@' . $tenant->domain,
                ], [
                    'tenant_id' => $tenant->id,
                    'brand_id' => $brand->id,
                    'name' => $tenant->name . ' Creator ' . $i,
                    'password' => bcrypt('password'),
                ]);
                if (!$creator->hasRole('creator')) {
                    $creator->assignRole('creator');
                }
                $users[] = $creator;
            }
            
            // Create 1 regular user
            $user = \App\Models\User::firstOrCreate([
                'email' => 'user@' . $tenant->domain,
            ], [
                'tenant_id' => $tenant->id,
                'brand_id' => $brand->id,
                'name' => $tenant->name . ' User',
                'password' => bcrypt('password'),
            ]);
            if (!$user->hasRole('user')) {
                $user->assignRole('user');
            }
            $users[] = $user;
            
            // Create 3 sample content items for each creator (6 total per tenant)
            // Also create 3 draft items for variety
            $contentCount = 1;
            foreach ($users as $index => $creatorUser) {
                // Skip the brand admin (index 0) and regular user (index 3)
                if ($index == 0 || $index == 3) {
                    continue;
                }
                
                // Create 3 content items for each creator
                for ($i = 1; $i <= 3; $i++) {
                    \App\Models\Content::firstOrCreate([
                        'title' => $tenant->name . ' Content Item ' . $contentCount,
                        'brand_id' => $brand->id,
                        'creator_id' => $creatorUser->id,
                    ], [
                        'body' => 'This is the content body for item ' . $contentCount . '. It contains sample text for demonstration purposes.',
                        'status' => ['draft', 'pending', 'published'][rand(0, 2)],
                    ]);
                    $contentCount++;
                }
            }
        }
    }
}
