<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\MessageThread;
use App\Models\Message;
use App\Models\MessageThreadParticipant;
use App\Models\User;
use App\Models\Proposal;

class MessagingDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get brand admin and creator users
        $brandUser = User::whereHas('roles', function ($query) {
            $query->where('name', 'brand_admin');
        })->first();
        
        $creatorUser = User::whereHas('roles', function ($query) {
            $query->where('name', 'creator');
        })->first();
        
        if (!$brandUser || !$creatorUser) {
            echo "Need at least one brand admin and one creator user to seed messages\n";
            return;
        }
        
        // Create a proposal
        $proposal = Proposal::factory()->create([
            'brand_id' => $brandUser->brand_id,
            'creator_id' => $creatorUser->id,
            'title' => 'Demo Proposal for Messaging',
            'message' => 'This is a demo proposal to test the messaging functionality.',
            'type' => 'Collaboration',
            'status' => 'sent',
        ]);
        
        // Create a message thread
        $thread = MessageThread::create([
            'subject' => 'Demo Thread for Proposal Discussion',
            'proposal_id' => $proposal->id,
        ]);
        
        // Add participants to the thread
        MessageThreadParticipant::create([
            'thread_id' => $thread->id,
            'user_id' => $brandUser->id,
            'joined_at' => now(),
        ]);
        
        MessageThreadParticipant::create([
            'thread_id' => $thread->id,
            'user_id' => $creatorUser->id,
            'joined_at' => now(),
        ]);
        
        // Create some messages in the thread
        Message::create([
            'thread_id' => $thread->id,
            'sender_id' => $brandUser->id,
            'recipient_id' => $creatorUser->id,
            'message' => 'Hi there! I wanted to discuss the proposal I sent you.',
        ]);
        
        Message::create([
            'thread_id' => $thread->id,
            'sender_id' => $creatorUser->id,
            'recipient_id' => $brandUser->id,
            'message' => 'Hello! Thanks for reaching out. I have a few questions about the deliverables.',
        ]);
        
        Message::create([
            'thread_id' => $thread->id,
            'sender_id' => $brandUser->id,
            'recipient_id' => $creatorUser->id,
            'message' => 'Sure, what would you like to know?',
        ]);
        
        echo "Seeded demo messaging data with thread ID: {$thread->id} and proposal ID: {$proposal->id}\n";
    }
}