<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class ReelsDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get demo users
        $brandUser = DB::table('users')->where('email', 'brand@demo.local')->first();
        $creatorUser = DB::table('users')->where('email', 'creator@demo.local')->first();
        
        if (!$brandUser || !$creatorUser) {
            echo "Demo users not found. Please run the default seeder first.\n";
            return;
        }
        
        // Get brand
        $brand = DB::table('brands')->where('id', $brandUser->brand_id)->first();
        
        if (!$brand) {
            echo "Brand not found for demo user.\n";
            return;
        }
        
        // Create demo scheduled reels for brand
        DB::table('scheduled_reels')->insert([
            [
                'owner_id' => $brand->id,
                'owner_type' => 'brand',
                'template' => 'template_1',
                'options' => json_encode([
                    'aspect_ratio' => '9:16',
                    'music' => 'Demo Music Track',
                    'overlay' => 'Demo Overlay Text'
                ]),
                'source_inputs' => json_encode([
                    [
                        'provider' => 'instagram',
                        'source_url' => 'https://example.com/demo-instagram-video.mp4',
                        'meta' => [
                            'caption' => 'Demo Instagram post for reel creation',
                            'created_at' => now()->subDays(2)->toISOString()
                        ]
                    ],
                    [
                        'provider' => 'youtube',
                        'source_url' => 'https://example.com/demo-youtube-video.mp4',
                        'meta' => [
                            'caption' => 'Demo YouTube video for reel creation',
                            'created_at' => now()->subDays(1)->toISOString()
                        ]
                    ]
                ]),
                'scheduled_at' => now()->addDays(1),
                'timezone' => 'Asia/Kolkata',
                'status' => 'scheduled',
                'created_by' => $brandUser->id,
                'created_at' => now()->subDays(3),
                'updated_at' => now()->subDays(3)
            ],
            [
                'owner_id' => $brand->id,
                'owner_type' => 'brand',
                'template' => 'template_2',
                'options' => json_encode([
                    'aspect_ratio' => '1:1',
                    'music' => 'Another Demo Track',
                    'overlay' => 'Another Overlay'
                ]),
                'source_inputs' => json_encode([
                    [
                        'provider' => 'tiktok',
                        'source_url' => 'https://example.com/demo-tiktok-video.mp4',
                        'meta' => [
                            'caption' => 'Demo TikTok video for reel creation',
                            'created_at' => now()->subDays(1)->toISOString()
                        ]
                    ]
                ]),
                'scheduled_at' => now()->addDays(2),
                'timezone' => 'Asia/Kolkata',
                'status' => 'scheduled',
                'created_by' => $brandUser->id,
                'created_at' => now()->subDays(2),
                'updated_at' => now()->subDays(2)
            ],
            [
                'owner_id' => $brand->id,
                'owner_type' => 'brand',
                'template' => 'template_1',
                'options' => json_encode([
                    'aspect_ratio' => '9:16',
                    'music' => 'Demo Music Track',
                    'overlay' => 'Demo Overlay Text'
                ]),
                'source_inputs' => json_encode([
                    [
                        'provider' => 'instagram',
                        'source_url' => 'https://example.com/demo-instagram-video.mp4',
                        'meta' => [
                            'caption' => 'Demo Instagram post for reel creation',
                            'created_at' => now()->subDays(2)->toISOString()
                        ]
                    ]
                ]),
                'scheduled_at' => now()->subHour(),
                'timezone' => 'Asia/Kolkata',
                'status' => 'queued',
                'created_by' => $brandUser->id,
                'created_at' => now()->subDays(1),
                'updated_at' => now()->subHour()
            ]
        ]);
        
        // Create demo scheduled reels for creator
        DB::table('scheduled_reels')->insert([
            [
                'owner_id' => $creatorUser->id,
                'owner_type' => 'creator',
                'template' => 'template_1',
                'options' => json_encode([
                    'aspect_ratio' => '9:16',
                    'music' => 'Creator Demo Music',
                    'overlay' => 'Creator Demo Overlay'
                ]),
                'source_inputs' => json_encode([
                    [
                        'provider' => 'instagram',
                        'source_url' => 'https://example.com/creator-instagram-video.mp4',
                        'meta' => [
                            'caption' => 'Creator demo Instagram post',
                            'created_at' => now()->subDays(3)->toISOString()
                        ]
                    ]
                ]),
                'scheduled_at' => now()->addHours(2),
                'timezone' => 'Asia/Kolkata',
                'status' => 'scheduled',
                'created_by' => $creatorUser->id,
                'created_at' => now()->subDays(4),
                'updated_at' => now()->subDays(4)
            ],
            [
                'owner_id' => $creatorUser->id,
                'owner_type' => 'creator',
                'template' => 'template_3',
                'options' => json_encode([
                    'aspect_ratio' => '4:5',
                    'music' => 'Another Creator Track',
                    'overlay' => 'Another Creator Overlay'
                ]),
                'source_inputs' => json_encode([
                    [
                        'provider' => 'youtube',
                        'source_url' => 'https://example.com/creator-youtube-video.mp4',
                        'meta' => [
                            'caption' => 'Creator demo YouTube video',
                            'created_at' => now()->subDays(2)->toISOString()
                        ]
                    ]
                ]),
                'scheduled_at' => now()->subMinutes(30),
                'timezone' => 'Asia/Kolkata',
                'status' => 'posting',
                'created_by' => $creatorUser->id,
                'created_at' => now()->subDays(3),
                'updated_at' => now()->subMinutes(30)
            ]
        ]);
        
        echo "Reels demo data seeded successfully.\n";
    }
}