<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the demo tenant
        $tenant = \App\Models\Tenant::where('domain', 'demo.local')->first();
        
        if (!$tenant) {
            throw new \Exception('Demo tenant not found. Please run TenantsSeeder first.');
        }
        
        // Get or create the demo user
        $user = \App\Models\User::firstOrCreate([
            'email' => 'user@demo.local'
        ], [
            'tenant_id' => $tenant->id,
            'name' => 'Demo User',
            'phone' => '123-456-7890',
            'password' => bcrypt('password123'),
        ]);
        
        // Assign user role if not already assigned
        if (!$user->hasRole('user')) {
            $user->assignRole('user');
        }
        
        // Create a sample subscription for the user
        $subscription = \App\Models\Subscription::firstOrCreate([
            'user_id' => $user->id,
            'tenant_id' => $tenant->id,
        ], [
            'plan' => 'Basic Plan',
            'status' => 'active',
        ]);
        
        // Create sample content items for the library
        $brand = \App\Models\Brand::where('tenant_id', $tenant->id)->first();
        
        if ($brand) {
            // Create published content items
            \App\Models\Content::firstOrCreate([
                'title' => 'Sample Article 1',
                'brand_id' => $brand->id,
            ], [
                'creator_id' => null,
                'body' => 'This is a sample published article that would be available in the user\'s library. It contains valuable information for the user.',
                'status' => 'published',
            ]);
            
            \App\Models\Content::firstOrCreate([
                'title' => 'Sample Article 2',
                'brand_id' => $brand->id,
            ], [
                'creator_id' => null,
                'body' => 'Another sample published article with useful content for users who have an active subscription.',
                'status' => 'published',
            ]);
            
            \App\Models\Content::firstOrCreate([
                'title' => 'Sample Article 3',
                'brand_id' => $brand->id,
            ], [
                'creator_id' => null,
                'body' => 'A third sample published article demonstrating how content would appear in the user\'s library view.',
                'status' => 'published',
            ]);
        }
    }
}
