# Login & Registration Pages — UI/UX Style Specification

**Project:** AI Business Market  
**Version:** 1.0  
**Last Updated:** 2025-09-30  
**Status:** Design Specification (No Code Implementation)

---

## 🎯 Overview

This document defines the complete UI/UX specifications for modern, conversion-optimized Login and Registration pages that align with the premium SaaS aesthetic of AI Business Market. These pages serve as the critical entry points for Brands, Creators, and Agencies.

### Design Philosophy
- **Mobile-First:** Responsive design starting from 320px width
- **Conversion-Focused:** Clear CTAs, minimal friction, trust signals
- **Premium Feel:** Modern, clean, professional SaaS aesthetic
- **Accessibility:** WCAG AA compliant with proper contrast and focus states
- **Brand Consistency:** Matches pricing page design language

---

## 🎨 Design System Foundation

### Color Palette

```
Primary Colors:
- Brand Primary: #3B82F6 (Blue-600) — Main CTAs, links, focus states
- Brand Secondary: #8B5CF6 (Purple-600) — Accents, gradients
- Brand Gradient: from-blue-600 to-purple-600

Neutral Colors:
- Background Base: #FFFFFF (White)
- Background Subtle: #F9FAFB (Gray-50)
- Background Gradient: from-blue-50 to-indigo-50
- Text Primary: #111827 (Gray-900)
- Text Secondary: #6B7280 (Gray-600)
- Border Default: #E5E7EB (Gray-200)
- Border Focus: #3B82F6 (Blue-600)

Semantic Colors:
- Success: #16A34A (Green-600)
- Error: #DC2626 (Red-600)
- Warning: #F59E0B (Amber-500)
- Info: #0EA5E9 (Sky-500)
```

### Typography

```
Font Family:
- Primary: 'Inter', 'Figtree', -apple-system, BlinkMacSystemFont, sans-serif
- Fallback: system-ui, sans-serif

Font Sizes:
- Headline (H1): 32px (mobile) / 40px (desktop), font-weight: 700
- Subheadline (H2): 24px, font-weight: 600
- Body Large: 18px, font-weight: 400
- Body Default: 16px, font-weight: 400
- Body Small: 14px, font-weight: 400
- Label: 14px, font-weight: 500
- Caption: 12px, font-weight: 400

Line Heights:
- Headlines: 1.2
- Body: 1.5
- Labels: 1.4
```

### Spacing System

```
Base Unit: 4px

Scale:
- xs: 4px (1 unit)
- sm: 8px (2 units)
- md: 16px (4 units)
- lg: 24px (6 units)
- xl: 32px (8 units)
- 2xl: 48px (12 units)
- 3xl: 64px (16 units)

Component Spacing:
- Between form fields: 16px (md)
- Section padding: 24px (lg) mobile / 32px (xl) desktop
- Card padding: 24px (lg) mobile / 32px (xl) desktop
```

### Border Radius

```
- Small: 6px (inputs, small buttons)
- Medium: 8px (cards, primary buttons)
- Large: 12px (modals, large cards)
- Full: 9999px (pills, toggles)
```

### Shadows

```
Card Shadow:
- Default: 0 1px 3px rgba(0, 0, 0, 0.1), 0 1px 2px rgba(0, 0, 0, 0.06)
- Hover: 0 10px 15px rgba(0, 0, 0, 0.1), 0 4px 6px rgba(0, 0, 0, 0.05)
- Focus: 0 0 0 3px rgba(59, 130, 246, 0.25)

Button Shadow:
- Default: 0 1px 2px rgba(0, 0, 0, 0.05)
- Hover: 0 4px 6px rgba(0, 0, 0, 0.1)
```

---

## 🔐 Login Page Specification

### Layout Structure

```
┌─────────────────────────────────────────┐
│         Background (Gradient)            │
│  ┌───────────────────────────────────┐  │
│  │                                   │  │
│  │         Logo (Optional)           │  │
│  │                                   │  │
│  │  ┌─────────────────────────────┐ │  │
│  │  │                             │ │  │
│  │  │      Login Card             │ │  │
│  │  │   (max-width: 420px)        │ │  │
│  │  │                             │ │  │
│  │  │  • Headline                 │ │  │
│  │  │  • Email Input              │ │  │
│  │  │  • Password Input           │ │  │
│  │  │  • Forgot Password Link     │ │  │
│  │  │  • Login Button (Primary)   │ │  │
│  │  │  • Divider (Optional)       │ │  │
│  │  │  • Social Login (Optional)  │ │  │
│  │  │  • Sign Up Link             │ │  │
│  │  │                             │ │  │
│  │  └─────────────────────────────┘ │  │
│  │                                   │  │
│  └───────────────────────────────────┘  │
│                                         │
└─────────────────────────────────────────┘
```

### Component Specifications

#### 1. Background
```
Desktop:
- Gradient: linear-gradient(135deg, #EFF6FF 0%, #E0E7FF 100%)
- Optional: Faded dashboard screenshot at 10% opacity
- Pattern: Subtle geometric pattern (optional)

Mobile:
- Simplified gradient
- No background image for performance
```

#### 2. Login Card
```
Dimensions:
- Max-width: 420px
- Min-height: auto
- Padding: 32px (desktop) / 24px (mobile)
- Margin: 40px auto (desktop) / 16px (mobile)

Styling:
- Background: #FFFFFF
- Border-radius: 12px
- Box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1)
- Border: 1px solid rgba(0, 0, 0, 0.05)
```

#### 3. Headline
```
Text: "Welcome Back" or "Sign In to Your Account"
Font-size: 28px (mobile) / 32px (desktop)
Font-weight: 700
Color: #111827
Margin-bottom: 8px
Text-align: center
```

#### 4. Subheadline (Optional)
```
Text: "Enter your credentials to access your account"
Font-size: 14px
Font-weight: 400
Color: #6B7280
Margin-bottom: 24px
Text-align: center
```

#### 5. Email Input Field
```
Label:
- Text: "Email Address"
- Font-size: 14px
- Font-weight: 500
- Color: #374151
- Margin-bottom: 6px

Input:
- Height: 44px
- Padding: 12px 16px
- Border: 1px solid #D1D5DB
- Border-radius: 8px
- Font-size: 16px
- Background: #FFFFFF
- Placeholder: "you@example.com"
- Placeholder color: #9CA3AF

States:
- Focus: Border #3B82F6, Box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1)
- Error: Border #DC2626, Background: #FEF2F2
- Success: Border #16A34A
- Disabled: Background #F3F4F6, Cursor: not-allowed

Icon (Optional):
- Email icon on left side
- Size: 20px
- Color: #9CA3AF
- Padding-left: 40px for input
```

#### 6. Password Input Field
```
Label:
- Text: "Password"
- Font-size: 14px
- Font-weight: 500
- Color: #374151
- Margin-bottom: 6px

Input:
- Same styling as Email Input
- Type: password
- Placeholder: "Enter your password"

Toggle Visibility Icon:
- Position: Absolute right, centered vertically
- Icon: Eye (show) / Eye-slash (hide)
- Size: 20px
- Color: #6B7280
- Hover: Color #374151
- Cursor: pointer
- Padding-right: 40px for input
```

#### 7. Forgot Password Link
```
Text: "Forgot password?"
Font-size: 14px
Font-weight: 500
Color: #3B82F6
Text-align: right
Margin-top: 8px
Margin-bottom: 24px

Hover:
- Color: #2563EB
- Text-decoration: underline
```

#### 8. Login Button (Primary CTA)
```
Dimensions:
- Width: 100%
- Height: 48px
- Padding: 12px 24px
- Border-radius: 8px

Styling:
- Background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%)
- Color: #FFFFFF
- Font-size: 16px
- Font-weight: 600
- Border: none
- Box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2)
- Cursor: pointer

States:
- Hover: Transform scale(1.02), Box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3)
- Active: Transform scale(0.98)
- Loading: Opacity 0.7, Cursor: wait, Spinner icon
- Disabled: Background #D1D5DB, Cursor: not-allowed

Transition: all 200ms ease-in-out

Icon (Optional):
- Lock icon on left
- Size: 18px
- Margin-right: 8px
```

#### 9. Divider (Optional)
```
Text: "or continue with"
Font-size: 12px
Color: #9CA3AF
Text-align: center
Margin: 24px 0

Line:
- Border-top: 1px solid #E5E7EB
- Position: relative to text
```

#### 10. Social Login Button (Optional)
```
Google Button:
- Width: 100%
- Height: 44px
- Background: #FFFFFF
- Border: 1px solid #D1D5DB
- Border-radius: 8px
- Font-size: 14px
- Font-weight: 500
- Color: #374151
- Margin-bottom: 12px

Icon:
- Google logo (colored)
- Size: 20px
- Margin-right: 12px

Hover:
- Background: #F9FAFB
- Border-color: #9CA3AF
```

#### 11. Sign Up Link
```
Container:
- Margin-top: 24px
- Padding-top: 24px
- Border-top: 1px solid #E5E7EB
- Text-align: center

Text: "Don't have an account?"
Font-size: 14px
Color: #6B7280

Link: "Sign up"
Font-size: 14px
Font-weight: 600
Color: #3B82F6
Margin-left: 4px

Hover:
- Color: #2563EB
- Text-decoration: underline
```

#### 12. Security Badge (Optional)
```
Position: Below password field or at card bottom
Icon: Lock icon
Size: 16px
Color: #10B981
Text: "Your data is secure and encrypted"
Font-size: 12px
Color: #6B7280
Display: flex, align-items: center
Gap: 6px
```

### Error States

```
Field Error:
- Border: 2px solid #DC2626
- Background: #FEF2F2
- Error message below field
- Font-size: 12px
- Color: #DC2626
- Icon: Alert circle (16px)
- Margin-top: 4px

Form Error (General):
- Alert box above form
- Background: #FEF2F2
- Border: 1px solid #FCA5A5
- Border-radius: 8px
- Padding: 12px 16px
- Color: #991B1B
- Icon: X-circle (20px)
- Margin-bottom: 16px
```

### Success States

```
Field Success:
- Border: 1px solid #16A34A
- Checkmark icon on right
- Icon color: #16A34A
- Size: 20px

Form Success:
- Alert box
- Background: #F0FDF4
- Border: 1px solid #86EFAC
- Color: #166534
- Icon: Check-circle
```

### Responsive Breakpoints

```
Mobile (< 640px):
- Card padding: 24px
- Font sizes: -2px from desktop
- Button height: 44px
- Full-width card with 16px margin

Tablet (640px - 1024px):
- Card max-width: 420px
- Centered layout
- Standard spacing

Desktop (> 1024px):
- Card max-width: 420px
- Centered with ample whitespace
- Optional background elements visible
```

---

## 📝 Registration Page Specification

### Layout Structure

```
┌─────────────────────────────────────────┐
│         Background (Gradient)            │
│  ┌───────────────────────────────────┐  │
│  │                                   │  │
│  │         Logo (Optional)           │  │
│  │                                   │  │
│  │  ┌─────────────────────────────┐ │  │
│  │  │                             │ │  │
│  │  │   Registration Card         │ │  │
│  │  │   (max-width: 500px)        │ │  │
│  │  │                             │ │  │
│  │  │  • Progress Indicator       │ │  │
│  │  │  • Headline                 │ │  │
│  │  │  • Name Input               │ │  │
│  │  │  • Email Input              │ │  │
│  │  │  • Role Selector            │ │  │
│  │  │  • Company Name (Cond.)     │ │  │
│  │  │  • Password Input           │ │  │
│  │  │  • Confirm Password         │ │  │
│  │  │  • Password Strength        │ │  │
│  │  │  • Terms Checkbox           │ │  │
│  │  │  • Create Account Button    │ │  │
│  │  │  • Login Link               │ │  │
│  │  │                             │ │  │
│  │  └─────────────────────────────┘ │  │
│  │                                   │  │
│  └───────────────────────────────────┘  │
│                                         │
└─────────────────────────────────────────┘
```

### Component Specifications

#### 1. Registration Card
```
Dimensions:
- Max-width: 500px (wider than login for more fields)
- Min-height: auto
- Padding: 32px (desktop) / 24px (mobile)
- Margin: 40px auto (desktop) / 16px (mobile)

Styling:
- Background: #FFFFFF
- Border-radius: 12px
- Box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1)
- Border: 1px solid rgba(0, 0, 0, 0.05)
```

#### 2. Progress Indicator (Multi-Step)
```
Layout:
- Display: flex, justify-content: space-between
- Margin-bottom: 32px
- Width: 100%

Step Item:
- Width: 32px
- Height: 32px
- Border-radius: 50%
- Background: #E5E7EB (inactive)
- Background: #3B82F6 (active)
- Background: #10B981 (completed)
- Color: #FFFFFF
- Font-size: 14px
- Font-weight: 600
- Display: flex, align-items: center, justify-content: center

Connector Line:
- Height: 2px
- Background: #E5E7EB (inactive)
- Background: #3B82F6 (active)
- Flex: 1
- Margin: 0 8px

Labels:
- Font-size: 12px
- Color: #6B7280 (inactive)
- Color: #3B82F6 (active)
- Margin-top: 8px
- Text-align: center
```

#### 3. Headline
```
Text: "Create Your Account" or "Get Started Free"
Font-size: 28px (mobile) / 32px (desktop)
Font-weight: 700
Color: #111827
Margin-bottom: 8px
Text-align: center
```

#### 4. Subheadline
```
Text: "Join 500+ brands and 2,000+ creators"
Font-size: 14px
Font-weight: 400
Color: #6B7280
Margin-bottom: 24px
Text-align: center
```

#### 5. Name Input Field
```
Label: "Full Name"
Same styling as Login Email Input
Placeholder: "John Doe"
Validation: Required, min 2 characters
Icon: User icon (optional)
```

#### 6. Email Input Field
```
Label: "Email Address"
Same styling as Login Email Input
Placeholder: "you@company.com"
Validation: Required, valid email format
Real-time validation: Check icon on valid email
Icon: Mail icon (optional)
```

#### 7. Role Selector
```
Label: "I am a..."
Font-size: 14px
Font-weight: 500
Color: #374151
Margin-bottom: 6px

Option 1: Dropdown Select
- Height: 44px
- Padding: 12px 16px
- Border: 1px solid #D1D5DB
- Border-radius: 8px
- Font-size: 16px
- Background: #FFFFFF
- Chevron icon on right

Options:
- "Select your role"
- "Brand Admin"
- "Creator / Influencer"
- "Agency"

Option 2: Segmented Control (Recommended)
- Display: flex
- Gap: 8px
- Margin-bottom: 16px

Button:
- Flex: 1
- Height: 48px
- Border: 2px solid #E5E7EB
- Border-radius: 8px
- Background: #FFFFFF
- Font-size: 14px
- Font-weight: 500
- Color: #6B7280
- Cursor: pointer
- Transition: all 200ms

Active State:
- Border: 2px solid #3B82F6
- Background: #EFF6FF
- Color: #3B82F6

Icon:
- Size: 24px
- Margin-bottom: 4px
- Display: block, margin: 0 auto
```

#### 8. Company Name Field (Conditional)
```
Visibility: Show only when "Brand Admin" or "Agency" selected
Label: "Company / Brand Name"
Same styling as Name Input
Placeholder: "Your Company Name"
Validation: Required if role is brand/agency
Animation: Slide down (200ms ease-in-out)
```

#### 9. Brand Handle Field (Conditional)
```
Visibility: Show only when "Brand Admin" selected
Label: "Brand Handle / Username"
Same styling as Name Input
Placeholder: "@yourbrand"
Validation: Alphanumeric, no spaces
Prefix: "@" symbol in input (gray)
```

#### 10. Password Input Field
```
Label: "Password"
Same styling as Login Password Input
Placeholder: "Create a strong password"
Toggle visibility icon
Validation: Min 8 characters, 1 uppercase, 1 number, 1 special char
```

#### 11. Confirm Password Field
```
Label: "Confirm Password"
Same styling as Password Input
Placeholder: "Re-enter your password"
Validation: Must match password field
Real-time validation: Show error if mismatch
```

#### 12. Password Strength Meter
```
Position: Below password field
Height: 4px
Border-radius: 2px
Background: #E5E7EB
Margin-top: 8px
Margin-bottom: 4px

Strength Bar:
- Height: 4px
- Border-radius: 2px
- Transition: width 300ms, background 300ms

Levels:
- Weak: Width 25%, Background #DC2626
- Fair: Width 50%, Background #F59E0B
- Good: Width 75%, Background #3B82F6
- Strong: Width 100%, Background #10B981

Label:
- Font-size: 12px
- Font-weight: 500
- Margin-top: 4px
- Color matches strength level
```

#### 13. Terms & Privacy Checkbox
```
Container:
- Display: flex
- Align-items: flex-start
- Gap: 12px
- Margin-top: 20px
- Margin-bottom: 24px

Checkbox:
- Width: 20px
- Height: 20px
- Border: 2px solid #D1D5DB
- Border-radius: 4px
- Cursor: pointer
- Flex-shrink: 0

Checked State:
- Background: #3B82F6
- Border-color: #3B82F6
- Checkmark: White, centered

Label:
- Font-size: 14px
- Color: #6B7280
- Line-height: 1.5

Links:
- Color: #3B82F6
- Font-weight: 500
- Text-decoration: none
- Hover: underline

Text: "I agree to the Terms of Service and Privacy Policy"
```

#### 14. Create Account Button
```
Same styling as Login Button
Text: "Create Account" or "Get Started Free"
Icon: Arrow-right or User-plus (optional)
Loading state: Spinner + "Creating account..."
```

#### 15. Login Link
```
Same styling as Login page Sign Up link
Text: "Already have an account? Log in"
Position: Below button, centered
Margin-top: 24px
Border-top: 1px solid #E5E7EB
Padding-top: 24px
```

#### 16. Social Registration (Optional)
```
Same styling as Login social buttons
Position: Above form or below divider
Text: "Sign up with Google"
```

### Validation & Error Handling

```
Real-time Validation:
- Email: Check format on blur
- Password: Show strength on input
- Confirm Password: Check match on input
- Company Name: Show if required based on role

Error Display:
- Inline below each field
- Red border on field
- Error icon (16px)
- Error message (12px, #DC2626)
- Shake animation on submit with errors

Success Indicators:
- Green checkmark on valid fields
- Green border on validated fields
- Smooth transitions (200ms)
```

### Multi-Step Flow (Recommended)

```
Step 1: Basic Info
- Name
- Email
- Role Selection
- Next Button

Step 2: Account Details
- Company Name (if applicable)
- Password
- Confirm Password
- Back Button + Create Account Button

Step 3: Success / Onboarding
- Success message
- Redirect to dashboard or onboarding wizard
- Animation: Confetti or checkmark
```

### Responsive Behavior

```
Mobile (< 640px):
- Single column layout
- Role selector: Stacked buttons
- Reduced padding: 20px
- Smaller font sizes
- Full-width inputs

Tablet (640px - 1024px):
- Card max-width: 500px
- Role selector: 2x2 grid or horizontal
- Standard spacing

Desktop (> 1024px):
- Card max-width: 500px
- Role selector: Horizontal segmented control
- Ample whitespace
- Optional side illustration
```

---

## 🎯 Shared Design Patterns

### Input Field States

```
Default:
- Border: 1px solid #D1D5DB
- Background: #FFFFFF
- Color: #111827

Focus:
- Border: 1px solid #3B82F6
- Box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1)
- Outline: none

Hover:
- Border: 1px solid #9CA3AF

Error:
- Border: 2px solid #DC2626
- Background: #FEF2F2
- Color: #991B1B

Success:
- Border: 1px solid #16A34A
- Icon: Checkmark (right side)

Disabled:
- Background: #F3F4F6
- Color: #9CA3AF
- Cursor: not-allowed
- Opacity: 0.6
```

### Button States

```
Primary Button:
- Default: Gradient blue
- Hover: Scale 1.02, enhanced shadow
- Active: Scale 0.98
- Focus: Ring shadow
- Loading: Opacity 0.7, spinner
- Disabled: Gray, no interaction

Secondary Button:
- Default: White background, gray border
- Hover: Light gray background
- Active: Darker gray background
```

### Animation Timings

```
Fast: 150ms (hover, active states)
Standard: 200ms (transitions, fades)
Slow: 300ms (slides, complex animations)
Easing: ease-in-out (default)
```

### Accessibility Requirements

```
Contrast Ratios:
- Text: Minimum 4.5:1 (WCAG AA)
- Large text: Minimum 3:1
- Interactive elements: Minimum 3:1

Focus Indicators:
- Visible on all interactive elements
- 3px ring with 20% opacity brand color
- Never remove outline without replacement

Keyboard Navigation:
- Tab order: logical flow
- Enter: Submit forms
- Escape: Close modals
- Arrow keys: Navigate options

Screen Readers:
- Proper ARIA labels
- Error announcements
- Success confirmations
- Loading states announced
```

### Loading States

```
Button Loading:
- Spinner icon (20px)
- Text: "Loading..." or specific action
- Disabled state
- Cursor: wait

Form Loading:
- Overlay with spinner
- Semi-transparent background
- "Processing..." message
- Prevent multiple submissions
```

---

## 📱 Mobile Optimization

### Touch Targets

```
Minimum Size: 44x44px
Recommended: 48x48px
Spacing: 8px minimum between targets
```

### Mobile-Specific Features

```
1. Auto-focus: First input on page load (desktop only)
2. Keyboard Type: Email keyboard for email inputs
3. Auto-capitalize: Off for email/password
4. Auto-correct: Off for email/password
5. Password managers: Support autofill
6. Biometric: Support Face ID / Touch ID where available
```

### Performance Targets

```
First Contentful Paint: < 1.5s
Time to Interactive: < 2.5s
Largest Contentful Paint: < 2.5s
Cumulative Layout Shift: < 0.1
```

---

## 🔒 Security & Trust Elements

### Trust Badges

```
Position: Footer of card or below form
Display: Flex, centered
Gap: 16px

Elements:
- SSL/HTTPS icon + "Secure Connection"
- Privacy icon + "Your data is encrypted"
- Shield icon + "GDPR Compliant"

Styling:
- Font-size: 12px
- Color: #6B7280
- Icon size: 16px
- Icon color: #10B981
```

### Social Proof (Optional)

```
Position: Above or below form
Text: "Join 500+ brands and 2,000+ creators"
Font-size: 14px
Color: #6B7280
Text-align: center
Icon: Users icon (optional)
```

---

## ✅ Acceptance Criteria Checklist

### Layout & Structure
- [ ] Login form centered, max-width 420px
- [ ] Registration form centered, max-width 500px
- [ ] Responsive on all screen sizes (320px+)
- [ ] No horizontal scroll on mobile
- [ ] Proper spacing and padding maintained

### Form Elements
- [ ] All inputs have labels and placeholders
- [ ] Password visibility toggle functional
- [ ] Role selector clearly visible and intuitive
- [ ] Company name field shows/hides based on role
- [ ] Terms checkbox required and functional

### Visual Design
- [ ] Consistent with pricing page aesthetic
- [ ] Brand colors applied correctly
- [ ] Proper typography hierarchy
- [ ] Shadows and borders as specified
- [ ] Smooth transitions (200ms)

### Interactive States
- [ ] Hover states on all interactive elements
- [ ] Focus states visible and accessible
- [ ] Error states clear with red borders
- [ ] Success states with green indicators
- [ ] Loading states with spinners

### Validation
- [ ] Real-time email validation
- [ ] Password strength meter functional
- [ ] Confirm password match validation
- [ ] Required field validation
- [ ] Clear error messages displayed

### Accessibility
- [ ] WCAG AA contrast ratios met
- [ ] Keyboard navigation functional
- [ ] Focus indicators visible
- [ ] Screen reader compatible
- [ ] Touch targets minimum 44px

### Performance
- [ ] Page loads < 2s
- [ ] Lighthouse accessibility score > 90
- [ ] No layout shifts
- [ ] Smooth animations
- [ ] Optimized images

### Mobile Experience
- [ ] Touch-friendly inputs (44px+)
- [ ] Proper keyboard types
- [ ] No auto-zoom on input focus
- [ ] Drawer-friendly layout
- [ ] Thumb-reachable CTAs

### Trust & Security
- [ ] Security badges visible
- [ ] HTTPS indicator
- [ ] Privacy policy linked
- [ ] Terms of service linked
- [ ] Social proof displayed (optional)

---

## 🎨 Design Assets Needed

### Icons (20px, 24px)
- Email / Mail
- Lock / Password
- Eye / Eye-slash
- User / Profile
- Building / Company
- Check / Checkmark
- X / Close
- Alert / Warning
- Info / Information
- Arrow-right
- Google logo (colored)

### Illustrations (Optional)
- Login hero illustration
- Registration success illustration
- Dashboard preview screenshot
- Abstract background patterns

### Brand Assets
- Logo (SVG, multiple sizes)
- Favicon
- Social media preview image

---

## 📐 Implementation Notes

### CSS Framework
- Tailwind CSS (already configured)
- Custom components for complex elements
- Utility-first approach

### JavaScript Requirements
- Form validation library
- Password strength calculator
- Role-based field visibility
- Real-time validation
- Loading state management

### Backend Integration Points
- Email uniqueness check API
- Password validation rules
- Role-based registration logic
- Social OAuth endpoints
- Session management

### Testing Requirements
- Cross-browser testing (Chrome, Firefox, Safari, Edge)
- Mobile device testing (iOS, Android)
- Accessibility audit (WAVE, axe)
- Performance testing (Lighthouse)
- User testing for conversion optimization

---

## 🚀 Future Enhancements

### Phase 2 Features
- Magic link login (passwordless)
- Two-factor authentication
- Social login (LinkedIn, Twitter)
- Progressive profiling
- Onboarding wizard
- Email verification flow
- Account recovery flow

### Analytics & Optimization
- Conversion tracking
- A/B testing framework
- Heatmap analysis
- Form abandonment tracking
- Error rate monitoring

---

## 📚 References

### Design Inspiration
- Stripe Dashboard
- Linear App
- Notion Login
- Figma Registration
- Vercel Auth Pages

### Accessibility Guidelines
- WCAG 2.1 Level AA
- WAI-ARIA Authoring Practices
- Material Design Accessibility

### Performance Standards
- Core Web Vitals
- Lighthouse Metrics
- PageSpeed Insights

---

**Document Status:** ✅ Complete  
**Next Steps:** Implementation in Code Mode  
**Approval Required:** Product Owner / Design Lead

---

*This specification document serves as the single source of truth for implementing the Login and Registration pages. All implementation should strictly follow these guidelines to ensure consistency, accessibility, and optimal user experience.*