// Reels Wizard Functionality
function initializeReelsWizard() {
    // Next step button
    $('.next-step').click(function() {
        const currentStep = $('.step.active');
        const nextStep = currentStep.next('.step');
        
        if (nextStep.length > 0) {
            currentStep.removeClass('active');
            nextStep.addClass('active');
        }
    });
    
    // Previous step button
    $('.prev-step').click(function() {
        const currentStep = $('.step.active');
        const prevStep = currentStep.prev('.step');
        
        if (prevStep.length > 0) {
            currentStep.removeClass('active');
            prevStep.addClass('active');
        }
    });
    
    // Post selection
    $('.post-checkbox').change(function() {
        const checkedCount = $('.post-checkbox:checked').length;
        const nextButton = $('.step-1 .next-step');
        
        if (checkedCount > 0) {
            nextButton.prop('disabled', false);
        } else {
            nextButton.prop('disabled', true);
        }
    });
    
    // Template selection
    $('.template-card').click(function() {
        // Remove active class from all template cards
        $('.template-card').removeClass('border-primary');
        $('.template-card').removeClass('bg-light');
        
        // Add active class to clicked card
        $(this).addClass('border-primary');
        $(this).addClass('bg-light');
        
        // Check the radio button
        const radio = $(this).find('.template-radio');
        radio.prop('checked', true);
    });
    
    // Form submission with validation
    $('#reel-form').submit(function(e) {
        const currentStep = $('.step.active');
        const stepNumber = currentStep.index('.step') + 1;
        
        // If we're not on the last step, prevent submission and go to next step
        if (stepNumber < 3) {
            e.preventDefault();
            currentStep.removeClass('active');
            currentStep.next('.step').addClass('active');
        }
    });
}

// Status polling function (optional)
function pollReelStatus(reelId, callback) {
    // This would call an API endpoint to check the status
    // For now, we'll just simulate it
    setTimeout(function() {
        // Simulate a response
        const status = Math.random() > 0.7 ? 'ready' : 'processing';
        callback(status);
    }, 3000);
}

// Export functions for global use
window.initializeReelsWizard = initializeReelsWizard;
window.pollReelStatus = pollReelStatus;