@extends('adminlte::page')

@section('title', 'AI Jobs')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">AI Jobs</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('superadmin.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">AI Jobs</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">All AI Jobs</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Job ID</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Brand</th>
                                    <th>Creator</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($aiJobs as $job)
                                <tr>
                                    <td>{{ $job->job_id }}</td>
                                    <td>{{ ucfirst(str_replace('_', ' ', $job->type)) }}</td>
                                    <td>
                                        <span class="badge 
                                            @if($job->status === 'queued') badge-warning
                                            @elseif($job->status === 'generating') badge-info
                                            @elseif($job->status === 'ready') badge-success
                                            @elseif($job->status === 'accepted') badge-primary
                                            @elseif($job->status === 'failed') badge-danger
                                            @else badge-secondary
                                            @endif">
                                            {{ ucfirst(str_replace('_', ' ', $job->status)) }}
                                        </span>
                                    </td>
                                    <td>{{ $job->brand->name }}</td>
                                    <td>{{ $job->creator ? $job->creator->name : 'N/A' }}</td>
                                    <td>{{ $job->created_at->format('M j, Y H:i') }}</td>
                                    <td>
                                        <a href="{{ route('admin.ai-jobs.show', $job->job_id) }}" class="btn btn-sm btn-primary">View</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer">
                        {{ $aiJobs->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection