@extends('adminlte::page')

@section('title', 'AI Job Details')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">AI Job Details</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('superadmin.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.ai-jobs.index') }}">AI Jobs</a></li>
                    <li class="breadcrumb-item active">Job Details</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Job Information</h3>
                    </div>
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-3">Job ID</dt>
                            <dd class="col-sm-9">{{ $aiJob->job_id }}</dd>
                            
                            <dt class="col-sm-3">Type</dt>
                            <dd class="col-sm-9">{{ ucfirst(str_replace('_', ' ', $aiJob->type)) }}</dd>
                            
                            <dt class="col-sm-3">Status</dt>
                            <dd class="col-sm-9">
                                <span class="badge 
                                    @if($aiJob->status === 'queued') badge-warning
                                    @elseif($aiJob->status === 'generating') badge-info
                                    @elseif($aiJob->status === 'ready') badge-success
                                    @elseif($aiJob->status === 'accepted') badge-primary
                                    @elseif($aiJob->status === 'failed') badge-danger
                                    @else badge-secondary
                                    @endif">
                                    {{ ucfirst(str_replace('_', ' ', $aiJob->status)) }}
                                </span>
                            </dd>
                            
                            <dt class="col-sm-3">Brand</dt>
                            <dd class="col-sm-9">{{ $aiJob->brand->name }}</dd>
                            
                            <dt class="col-sm-3">Creator</dt>
                            <dd class="col-sm-9">{{ $aiJob->creator ? $aiJob->creator->name : 'N/A' }}</dd>
                            
                            <dt class="col-sm-3">Provider</dt>
                            <dd class="col-sm-9">{{ $aiJob->provider ?? 'N/A' }}</dd>
                            
                            <dt class="col-sm-3">Token Usage</dt>
                            <dd class="col-sm-9">{{ $aiJob->token_usage ?? 'N/A' }}</dd>
                            
                            <dt class="col-sm-3">Created At</dt>
                            <dd class="col-sm-9">{{ $aiJob->created_at->format('M j, Y H:i') }}</dd>
                            
                            <dt class="col-sm-3">Completed At</dt>
                            <dd class="col-sm-9">{{ $aiJob->completed_at ? $aiJob->completed_at->format('M j, Y H:i') : 'N/A' }}</dd>
                            
                            @if($aiJob->error_message)
                            <dt class="col-sm-3">Error Message</dt>
                            <dd class="col-sm-9 text-danger">{{ $aiJob->error_message }}</dd>
                            @endif
                        </dl>
                        
                        @if($aiJob->proposal)
                        <div class="mt-4">
                            <h4>Generated Proposal</h4>
                            <p>
                                <a href="{{ route('brand.proposals.show', $aiJob->proposal) }}" class="btn btn-primary">
                                    View Proposal
                                </a>
                            </p>
                        </div>
                        @endif
                        
                        <div class="mt-4">
                            <h4>Actions</h4>
                            <form action="{{ route('admin.ai-jobs.rerun', $aiJob->job_id) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-warning" 
                                        onclick="return confirm('Are you sure you want to re-run this AI job?')">
                                    Re-run Job
                                </button>
                            </form>
                            
                            <button type="button" class="btn btn-info" id="view-logs">
                                View Logs
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-3" id="logs-card" style="display: none;">
                    <div class="card-header">
                        <h3 class="card-title">Job Logs</h3>
                    </div>
                    <div class="card-body">
                        <pre id="logs-content">Loading logs...</pre>
                    </div>
                </div>
                
                @if($aiJob->result_text)
                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">AI Generated Result</h3>
                    </div>
                    <div class="card-body">
                        <pre>{{ $aiJob->result_text }}</pre>
                    </div>
                </div>
                @endif
                
                @if($aiJob->result_meta)
                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">AI Generated Metadata</h3>
                    </div>
                    <div class="card-body">
                        <pre>{{ json_encode($aiJob->result_meta, JSON_PRETTY_PRINT) }}</pre>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('view-logs').addEventListener('click', function() {
        const logsCard = document.getElementById('logs-card');
        const logsContent = document.getElementById('logs-content');
        
        // Show the logs card
        logsCard.style.display = 'block';
        
        // Fetch logs
        fetch('{{ route('admin.ai-jobs.logs', $aiJob->job_id) }}')
            .then(response => response.json())
            .then(data => {
                logsContent.textContent = data.logs.join('\n');
            })
            .catch(error => {
                console.error('Error fetching logs:', error);
                logsContent.textContent = 'Error loading logs.';
            });
    });
});
</script>
@endsection