@extends('layouts.app')

@section('title', 'Create AI Proposal for Client Brand')

@section('content')
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="px-4 py-6 sm:px-0">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-900">Create AI Proposal for Client Brand</h1>
            <a href="{{ route('agency.dashboard') }}" class="text-blue-600 hover:text-blue-800">
                &larr; Back to Dashboard
            </a>
        </div>

        <div class="bg-white shadow overflow-hidden sm:rounded-lg">
            <div class="px-4 py-5 sm:px-6">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Proposal Details</h3>
                <p class="mt-1 max-w-2xl text-sm text-gray-500">Create an AI-generated proposal for your client brand.</p>
            </div>
            <div class="border-t border-gray-200">
                <div class="px-4 py-5 sm:px-6">
                    @if($assignedBrands->isEmpty())
                        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm text-yellow-700">
                                        You have no assigned brands. Please contact your administrator to get assigned to brands.
                                    </p>
                                </div>
                            </div>
                        </div>
                    @else
                        <form id="aiProposalForm" method="POST" action="{{ route('agency.ai-proposals.store') }}">
                            @csrf
                            
                            <div class="mb-4">
                                <label for="brand_id" class="block text-sm font-medium text-gray-700">Client Brand</label>
                                <select name="brand_id" id="brand_id" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md" required>
                                    <option value="">Select a client brand</option>
                                    @foreach($assignedBrands as $brand)
                                        <option value="{{ $brand->id }}" {{ (isset($selectedBrand) && $selectedBrand->id == $brand->id) ? 'selected' : '' }}>
                                            {{ $brand->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <p class="mt-2 text-sm text-gray-500">You can only create proposals for brands assigned to you.</p>
                            </div>
                            
                            <div class="mb-4">
                                <label for="creator_id" class="block text-sm font-medium text-gray-700">Creator (Optional)</label>
                                <select name="creator_id" id="creator_id" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                    <option value="">Select a creator (optional)</option>
                                    @foreach($creators as $creator)
                                        <option value="{{ $creator->id }}">
                                            {{ $creator->name }} ({{ $creator->email }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="mb-4">
                                <label for="campaign_brief" class="block text-sm font-medium text-gray-700">Campaign Brief</label>
                                <textarea name="campaign_brief" id="campaign_brief" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" rows="5" required></textarea>
                                <p class="mt-2 text-sm text-gray-500">Describe your campaign in detail. PII will be automatically sanitized.</p>
                            </div>
                            
                            <div class="mb-4">
                                <label for="tone" class="block text-sm font-medium text-gray-700">Tone of Voice</label>
                                <input type="text" name="tone" id="tone" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" required>
                                <p class="mt-2 text-sm text-gray-500">e.g., Professional, Friendly, Humorous, etc.</p>
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700">Budget Range</label>
                                <div class="grid grid-cols-2 gap-4 mt-1">
                                    <div>
                                        <label for="budget_min" class="block text-sm font-medium text-gray-700">Minimum</label>
                                        <input type="number" name="budget_range[0]" id="budget_min" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Minimum" required>
                                    </div>
                                    <div>
                                        <label for="budget_max" class="block text-sm font-medium text-gray-700">Maximum</label>
                                        <input type="number" name="budget_range[1]" id="budget_max" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Maximum" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700">Deliverables</label>
                                <div id="deliverables-container" class="mt-1">
                                    <div class="flex items-center mb-2">
                                        <input type="text" name="deliverables[]" class="block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Deliverable" required>
                                        <button type="button" class="ml-2 remove-deliverable text-red-600 hover:text-red-800">&times;</button>
                                    </div>
                                </div>
                                <button type="button" id="add-deliverable" class="mt-2 inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm leading-4 font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Add Deliverable
                                </button>
                            </div>
                            
                            <div class="mt-6">
                                <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Generate Proposal
                                </button>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add deliverable button
    document.getElementById('add-deliverable').addEventListener('click', function() {
        const container = document.getElementById('deliverables-container');
        const newInput = document.createElement('div');
        newInput.className = 'flex items-center mb-2';
        newInput.innerHTML = `
            <input type="text" name="deliverables[]" class="block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Deliverable" required>
            <button type="button" class="ml-2 remove-deliverable text-red-600 hover:text-red-800">&times;</button>
        `;
        container.appendChild(newInput);
    });
    
    // Remove deliverable button
    document.getElementById('deliverables-container').addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-deliverable')) {
            if (document.querySelectorAll('#deliverables-container .flex').length > 1) {
                e.target.closest('.flex').remove();
            } else {
                alert('At least one deliverable is required.');
            }
        }
    });
    
    // Form submission
    document.getElementById('aiProposalForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        fetch(this.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success message
                alert(data.message);
                // Redirect to show page
                if (data.job_id) {
                    window.location.href = '{{ url('agency/ai-proposals') }}/' + data.job_id;
                } else {
                    window.location.href = '{{ route('agency.dashboard') }}';
                }
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while generating the proposal.');
        });
    });
});
</script>
@endsection