@extends('layouts.app')

@section('title', 'AI Generated Proposal')

@section('content')
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="px-4 py-6 sm:px-0">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-900">AI Generated Proposal</h1>
            <a href="{{ route('agency.dashboard') }}" class="text-blue-600 hover:text-blue-800">
                &larr; Back to Dashboard
            </a>
        </div>

        <div class="bg-white shadow overflow-hidden sm:rounded-lg">
            <div class="px-4 py-5 sm:px-6">
                <div class="flex justify-between items-center">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Proposal Preview</h3>
                    <span class="badge 
                        @if($aiJob->status === 'queued') bg-yellow-100 text-yellow-800
                        @elseif($aiJob->status === 'generating') bg-blue-100 text-blue-800
                        @elseif($aiJob->status === 'ready') bg-green-100 text-green-800
                        @elseif($aiJob->status === 'accepted') bg-purple-100 text-purple-800
                        @elseif($aiJob->status === 'failed') bg-red-100 text-red-800
                        @else bg-gray-100 text-gray-800
                        @endif">
                        {{ ucfirst(str_replace('_', ' ', $aiJob->status)) }}
                    </span>
                </div>
                <p class="mt-1 max-w-2xl text-sm text-gray-500">Review and finalize your AI-generated proposal.</p>
            </div>
            <div class="border-t border-gray-200">
                <div class="px-4 py-5 sm:px-6">
                    @if($aiJob->status === 'failed')
                        <div class="bg-red-50 border-l-4 border-red-400 p-4 mb-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 101.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm text-red-700">
                                        <strong>Error Generating Proposal:</strong> {{ $aiJob->error_message ?? 'An unknown error occurred during proposal generation.' }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @elseif($aiJob->status === 'queued' || $aiJob->status === 'generating')
                        <div class="text-center py-10">
                            <div class="spinner-border inline-block h-8 w-8 border-4 rounded-full border-blue-500 border-t-transparent animate-spin"></div>
                            <p class="mt-4 text-lg text-gray-600">Your proposal is being generated. This may take a few moments.</p>
                        </div>
                        
                        <script>
                        // Poll for status updates if still generating
                        const pollInterval = setInterval(function() {
                            fetch('{{ route('agency.ai-proposals.show', $aiJob->job_id) }}', {
                                headers: {
                                    'X-Requested-With': 'XMLHttpRequest'
                                }
                            })
                            .then(response => response.text())
                            .then(html => {
                                // Check if status has changed to ready
                                if (html.includes('Proposal Preview') && !html.includes('Loading...')) {
                                    clearInterval(pollInterval);
                                    window.location.reload();
                                }
                            })
                            .catch(error => {
                                console.error('Polling error:', error);
                            });
                        }, 5000); // Poll every 5 seconds
                        </script>
                    @elseif($aiJob->status === 'ready' || $aiJob->status === 'accepted')
                        <form id="proposalForm" method="POST" action="{{ route('agency.ai-proposals.update', $aiJob->job_id) }}">
                            @csrf
                            @method('PUT')
                            
                            <input type="hidden" name="job_id" value="{{ $aiJob->job_id }}">
                            
                            <div class="mb-6">
                                <label for="title" class="block text-sm font-medium text-gray-700">Proposal Title</label>
                                <input type="text" name="title" id="title" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" value="{{ $aiJob->result_meta['title'] ?? '' }}" required>
                            </div>
                            
                            <div class="mb-6">
                                <label for="price_estimate" class="block text-sm font-medium text-gray-700">Price Estimate</label>
                                <input type="number" name="price_estimate" id="price_estimate" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" 
                                       value="{{ $aiJob->result_meta['price_estimate'] ?? '' }}" step="0.01" min="0" required>
                            </div>
                            
                            <h4 class="text-md font-medium text-gray-900 mb-4">Proposal Sections</h4>
                            <div id="sections-container" class="mb-6">
                                @if(isset($aiJob->result_meta['sections']) && is_array($aiJob->result_meta['sections']))
                                    @foreach($aiJob->result_meta['sections'] as $index => $section)
                                        <div class="card mb-4 section-card" data-section-index="{{ $index }}">
                                            <div class="border border-gray-200 rounded-md shadow-sm p-4">
                                                <div class="mb-3">
                                                    <input type="text" name="sections[{{ $index }}][title]" 
                                                           class="form-control section-title block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" 
                                                           value="{{ $section['title'] ?? 'Section ' . ($index + 1) }}" required>
                                                </div>
                                                <div>
                                                    <textarea name="sections[{{ $index }}][content]" 
                                                              class="form-control section-content block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" 
                                                              rows="5" required>{{ $section['content'] ?? '' }}</textarea>
                                                    <input type="hidden" name="sections[{{ $index }}][order]" value="{{ $index }}">
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="card mb-4 section-card" data-section-index="0">
                                        <div class="border border-gray-200 rounded-md shadow-sm p-4">
                                            <div class="mb-3">
                                                <input type="text" name="sections[0][title]" 
                                                       class="form-control section-title block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" 
                                                       value="Introduction" required>
                                            </div>
                                            <div>
                                                <textarea name="sections[0][content]" 
                                                          class="form-control section-content block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" 
                                                          rows="5" required></textarea>
                                                <input type="hidden" name="sections[0][order]" value="0">
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="mb-4">
                                <button type="button" id="add-section" class="inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm leading-4 font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Add Section
                                </button>
                            </div>
                            
                            <div class="mt-6 flex space-x-3">
                                <button type="button" id="save-draft" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Save Draft
                                </button>
                                <button type="button" id="request-approval" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Request Client Approval
                                </button>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add section button
    document.getElementById('add-section').addEventListener('click', function() {
        const container = document.getElementById('sections-container');
        const sectionCount = container.querySelectorAll('.section-card').length;
        const newSection = document.createElement('div');
        newSection.className = 'card mb-4 section-card';
        newSection.dataset.sectionIndex = sectionCount;
        newSection.innerHTML = `
            <div class="border border-gray-200 rounded-md shadow-sm p-4">
                <div class="mb-3">
                    <input type="text" name="sections[${sectionCount}][title]" 
                           class="form-control section-title block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" 
                           value="Section ${sectionCount + 1}" required>
                </div>
                <div>
                    <textarea name="sections[${sectionCount}][content]" 
                              class="form-control section-content block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" 
                              rows="5" required></textarea>
                    <input type="hidden" name="sections[${sectionCount}][order]" value="${sectionCount}">
                </div>
            </div>
        `;
        container.appendChild(newSection);
    });
    
    // Save draft button
    document.getElementById('save-draft').addEventListener('click', function() {
        submitForm('save_draft');
    });
    
    // Request approval button
    document.getElementById('request-approval').addEventListener('click', function() {
        if (confirm('Are you sure you want to request client approval for this proposal?')) {
            submitForm('request_approval');
        }
    });
    
    // Form submission
    function submitForm(action) {
        const form = document.getElementById('proposalForm');
        const formData = new FormData(form);
        formData.append('action', action);
        
        fetch(form.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
                if (data.redirect) {
                    window.location.href = data.redirect;
                } else {
                    // Reload the page to show updated status
                    window.location.reload();
                }
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while processing your request.');
        });
    }
});
</script>
@endsection